<?php
// Checks how ((relative/path)) is corrected e.g. in {{Include other/path/doc}}
// (the link must be converted to other/path/relative/path).

class UtirpPager extends UWikiPagerStub {
  function ReadPage($file, $format = null) { return $GLOBALS['tirpIncludes'][$file]; }
}

class Utirp_dynamic_Root extends UWikiBaseAction {
  function IsDynamic($format, $params) { return true; }
  function Execute($format, $params) { }
}


  $GLOBALS['tirpIncludes'] = array('relative\\path/doc' => '
((../some\\doc))
((../some\\cluster/))
((/abs\\path))
((http://i-forge.net/imageboards))
');

  $doc = new UWikiDocument('{{Include relative\\path/doc}}');
  $doc->settings = $settings;
  $doc->settings->pager = new UtirpPager;
  $doc->LoadMarkup('wacko');

  $doc->Parse();
  $html = $doc->ToHTML();

$expectedHTML = '
<a name="relative" href="#relative" title="#relative" class="anchor include block-anchor">
¶
</a>
<p class="default">
<a href="/root/base/relative/path/../some/doc" title="../some/doc" class="round-brackets internal">doc</a>
<a href="/root/base/relative/path/../some/cluster/" title="../some/cluster/" class="round-brackets internal">cluster</a>
<a href="/root/abs/path" title="/abs/path" class="round-brackets internal">path</a>
<a href="http://i-forge.net/imageboards" title="http://i-forge.net/imageboards" target="_blank" class="round-brackets external">[i-forge.net]</a>
<a name="p_0-1" href="#p_0-1" title="#p_0-1" class="anchor">¶</a>
</p>';

  TestEquality( preg_replace('/(\r?\n)+/u', "\n", trim($html)), trim($expectedHTML) );
